UNIT SeekBuf;

INTERFACE
USES
  Strings, DOS;

TYPE
  TSuchWorte = Array[1..2] Of String;


PROCEDURE InitNotCaseSensSearch (Suchwort : String; VAR SuchWorte : TSuchworte);

FUNCTION  NotCaseSensPos (VAR SuchWorte : TSuchworte; VAR Buffer; BufSize : Word) : Word;
FUNCTION  CaseSensPos    (SuchStr       : String;     VAR Buffer; BufSize : Word) : Word;

PROCEDURE KonvertBuf     (VAR Buffer; BufSize : Word);


IMPLEMENTATION

CONST
  StrSize = SizeOf (TSuchWorte) shr 1;


PROCEDURE InitNotCaseSensSearch (Suchwort : String; VAR SuchWorte : TSuchworte);
BEGIN
  SuchWorte[1]:= LowStr (SuchWort);
  Suchworte[2]:= UpStr  (SuchWort);
END;
{ mu einmalig vor der Suche mit NotCaseSensPos aufgerufen werden }



FUNCTION NotCaseSensPos (VAR SuchWorte : TSuchworte; VAR Buffer; BufSize : Word) : Word; assembler;
ASM
  cld
  push ds
  les  di, Buffer;    mov cx, BufSize;   jcxz @raus
  lds  si, SuchWorte; lodsw;  or al, al; jz   @raus
  xchg al, ah
  mov  dl, al            { erstes Zeichen des ersten  Strings in dl }
  dec  si
  mov  dh, [si+StrSize]  { erstes Zeichen des zweiten Strings in dh }

  dec  ah          { Suchwortlnge; eins runter, da das erste Zeichen nicht
                     nochmal gesucht zu werden braucht }
  mov  bx, cx      { CX in BX merken }

  @nextchar:
    mov  al, es:[di]
    inc  di
    cmp  al, dl
    je   @check
    cmp  al, dh
    je   @check
  loop @nextchar
  jmp  @raus

  @check:
    dec  cx
    or   ah, ah
    jz   @okay
    jcxz @raus
    push cx
    push si
    push di
    mov  cl, ah    
    xor  ch, ch
    @nochmal:
      mov  al, es:[di]
      inc  di
      inc  si
      cmp  al, [si]
      je   @weiter
      cmp  al, [si+StrSize]
      @weiter:
    loope @nochmal
    pop  di
    pop  si
    pop  cx
    jne  @nextchar
    @okay:
    sub  bx, cx
    mov  ax, bx
    jmp  @gefunden
  @raus:
  xor  ax, ax
  @gefunden:
  pop  ds
END;
{ Findet das Suchwort unabhngig von Gro und Kleinschreibung }



FUNCTION CaseSensPos (SuchStr : String; VAR Buffer; BufSize : Word) : Word; assembler;
ASM
  push ds
  cld
  lds  si, SuchStr; lodsw; or  al, al; jz   @raus
  les  di, Buffer;  mov cx, BufSize;   jcxz @raus

  dec  al          { eins runter, da das erste Zeichen nicht von CMPSB
                     gesucht zu werden braucht (macht scasb) }
  xchg al, ah      { Lnge SuchStr in AH, erstes Zeichen in AL }
  mov  bx, cx

  @nochmal:
  repne scasb
  jne   @raus      { nichts gefunden }
    push cx
    push si
    push di
    mov  cl, ah  
    xor  ch, ch
    repe cmpsb
    pop  di
    pop  si
    pop  cx
    jne  @nochmal
    sub  bx, cx
    mov  ax, bx
    jmp  @gefunden
  @raus:
  xor  ax, ax
  @gefunden:
  pop  ds
END;


PROCEDURE KonvertBuf (VAR Buffer; BufSize : Word); assembler;
ASM
  cld
  mov  cx, BufSize
  jcxz @ende
  push ds
  lds  si, Buffer

  mov  bl, 196; mov bh, 228; mov ah, 246; mov dl, 223; mov dh, 252

  @nextchar:
    lodsb
    cmp  al, bl
    jae  @konvert
    loop @nextchar
    jmp  @fertig
  @konvert:
      cmp al, dh;  jne @1;     mov al, ''; jmp @store
  @1: cmp al, dl;  jne @2;     mov al, ''; jmp @store
  @2: cmp al, bh;  jne @3;     mov al, ''; jmp @store
  @3: cmp al, ah;  jne @4;     mov al, ''; jmp @store
  @4: cmp al, bl;  jne @5;     mov al, ''; jmp @store
  @5: cmp al, 214; jne @6;     mov al, ''; jmp @store
  @6: cmp al, 220; jne @store; mov al, ''

@store:
  mov [si-1], al
  loop @nextchar

@fertig:
  pop ds
@ende:
END;
{ Konvertiert die Umlaute im Puffer von Windows nach DOS }


END.



{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
