UNIT Strings;

INTERFACE
USES
  DOS;

TYPE
  Str2  = String[2];
  Str3  = String[3];
  Str4  = String[4];
  Str5  = String[5];
  Str15 = String[15];


PROCEDURE StrCopy  (Quelle   : String;  VAR Ziel);
PROCEDURE StrCat   (VAR Ziel;  Q1, Q2   : String);
PROCEDURE StrAdd   (VAR Q1;    Q2       : String);
PROCEDURE CharAdd  (VAR Q1;    Zeichen  : Char  );

FUNCTION  PosCount (SuchStr, QuellStr : String) : Byte;
FUNCTION  FirstPos (SuchStr, QuellStr : String) : Byte;
FUNCTION  LastPos  (SuchStr, QuellStr : String) : Byte;
FUNCTION  nthPos   (SuchStr, QuellStr : String; Index : Word) : Byte;
FUNCTION  Trim     (OrigStr : String) : String;
FUNCTION  InStr    (Start : Byte; OrigStr, SeekStr : String) : Byte;
FUNCTION  LastInStr(Start : Byte; OrigStr, SeekStr : String) : Byte;

FUNCTION  ReplaceAll   (OrigStr, SeekStr, ErsatzStr : String) : String;
FUNCTION  CountFields  (OrigStr : String; Separator : Char)   : Byte;
FUNCTION  nthField     (OrigStr : String; Separator : Char; n : Byte) : String;
FUNCTION  FromNthField (OrigStr : String; Separator : Char; n : Byte) : String;
FUNCTION  ChangeField  (OrigStr : String; Separator : Char; n : Byte; NewStr : String) : String;

FUNCTION  UpChar    (Cha : Char)          : Char;
FUNCTION  LowChar   (Cha : Char)          : Char;
FUNCTION  UpStr     (s   : String)        : String;
FUNCTION  LowStr    (s   : String)        : String;
FUNCTION  BuildPath (Pfad, Datei: String) : String;

PROCEDURE StretchParam (VAR TempBuf       : String);
FUNCTION  CmdLine                         : String;

FUNCTION  IsPlus        (Path : String) : Boolean;
FUNCTION  GetFileName   (Path : String) : String;
FUNCTION  GetPathName   (Path : String) : String;
FUNCTION  GetFileExt    (Path : String) : String;
FUNCTION  GetFilePrefix (Path : String) : String;
FUNCTION  ChangeFileExt (Path : String; NewExt : Str3) : String;
FUNCTION  ShrinkPath    (x    : Byte;   Path : String) : String;
FUNCTION  DelLastSlash  (Path : String) : String;

FUNCTION  LZ      (w : Word)    : String;
FUNCTION  LS      (w : Word)    : String;
FUNCTION  IntVal  (s : String)  : LongInt;
FUNCTION  StrVal  (x : LongInt) : String;
FUNCTION  TPkt    (s : String)  : String;
FUNCTION  TausPkt (x : LongInt) : String;

FUNCTION  FillString   (Len : Byte) : String;
FUNCTION  StretchRight (ein : String; Len    : Word) : String;
FUNCTION  StretchLeft  (ein : String; Len    : Word) : String;
FUNCTION  BreakLine    (s   : String; MaxLen : Byte) : String;

FUNCTION  ASCIIZtoPascal (VAR ein) : String;
PROCEDURE PascalToASCIIZ (ein : String; VAR aus; OutBufSize : Byte);

FUNCTION  SameFile   (p1, p2 : PathStr) : Boolean;


IMPLEMENTATION



PROCEDURE StrCopy (Quelle : String; VAR Ziel); assembler;
ASM
  mov bx, ds           {DS-Register in BX zwischenspeichern. Wichtig!}
  les di, Ziel         {Startadresse von Ziel in ES:DI laden}
  lds si, Quelle       {Startadresse von Quelle in DS:SI laden}
  cld                  {Adressen sollen hochgezhlt werden}
  lodsW                {Lade die ersten zwei Zeichen}
  stosW                {schreibe diese}

  mov cx, ax           {bernehme Lngenbyte aus AL-Register}
  xor ch, ch           
  shr cx, 1            {Inhalt von CX durch Zwei teilen}
  rep movsW            {kopiere sooft, bis CX = Null}

  mov ds, bx           {Restauriere DS-Register. Wichtig!}
END;
{schnellerer Ersatz fr Str1:= Str2 --> StrCopy (Str2, Str1)}


PROCEDURE StrCat (VAR Ziel; Q1, Q2 : String); assembler;
ASM
  push ds
  cld
  les  di, Ziel
  push di
  inc  di
  lds  si, Q1
  lodsb
  xor  ah, ah
  mov  dx, ax
  mov  cx, ax
  rep  movsb
  cmp  dx, 255
  je   @ende

  lds  si, Q2
  lodsb
  xor  ah, ah
  mov  bx, ax
  add  bx, dx           {Resultierende Lnge}
  or   bh, bh           { "" lnger als 255 ?}
  jz   @los
    sub bx, 255         { um wieviele Zeichen zu lang ? }
    sub ax, bx
  @los:
  mov  cx, ax
  rep  movsb
  add  dl, al

  @ende:
  pop  di
  mov  al, dl
  stosb
  pop  ds
END;
{schnellerer Ersatz fr Str1:= Str2+Str3 --> StrCat (Str1, Str2, Str3)}



PROCEDURE StrAdd (VAR Q1; Q2 : String); assembler;
ASM
  push ds              {DS-Register zwischenspeichern. Wichtig!}
  les di, Q1           {Startadresse von Ziel in ES:DI laden}
  lds si, Q2           {Startadresse von Quelle1 in DS:SI laden}
  cld                  {Adressen sollen hochgezhlt werden}

  xor dh, dh
  mov dl, es:[di]      {dx=Lnge Quellstring }
  cmp dl, 255
  je  @raus
  lodsB                {ax=Lnge anzuhngender String}
  xor ah, ah
  mov bx, ax
  add bx, dx           {Resultierende Lnge}
  or  bh, bh           { "" lnger als 255 ?}
  jz  @los
    sub bx, 255        { um wieviele Zeichen zu lang ? }
    sub ax, bx
  @los:
  mov cx, ax
  add al, dl
  stosB
  add di, dx
  rep movsb
  @raus:
  pop ds               {Restauriere DS-Register. Wichtig!}
END;
{Mehrfach schnellerer Ersatz fr Str1:= Str1+Str2 --> StrAdd (Str1, Str2)}



PROCEDURE CharAdd (VAR Q1; Zeichen : Char); assembler;
ASM
  cld
  xor ax, ax
  les di, Q1           { Startadresse von Ziel in ES:DI laden }
  mov al, es:[di]
  inc al
  jz  @ende            { berlauf? }
  stosB
  dec ax
  add di, ax
  mov al, Zeichen
  Stosb
  @ende:
END;
{Mehrfach schnellerer Ersatz fr Str1:= Str1+Char --> CharAdd (Str1, Char)}



FUNCTION PosCount (SuchStr, QuellStr : String) : Byte; assembler;
ASM
  push ds
  xor  bx, bx
  cld
  lds  si, SuchStr;  lodsw;             or  al, al; jz   @raus
  les  di, QuellStr; mov cl, es:[di];   xor ch, ch; jcxz @raus { Lnge Quelle}
  dec  al          { eins runter, da das erste Zeichen nicht von CMPSB
                     geprft zu werden braucht (macht scasb) }
  xchg al, ah      { Lnge SuchStr in AH, erstes Zeichen in AL }
  inc  di          { Zeiger auf erstes Zeichen des zu durchsuchenden Strings }

  @nochmal:
  repne scasb
  jne   @raus      { nichts gefunden }
    push cx
    push si
    push di
    mov  cl, ah    { ch ist bereits 0 }
    repe cmpsb
    pop  di
    pop  si
    pop  cx
    jne  @nochmal
    inc  bx
    jmp  @nochmal
  @raus:
  mov  ax, bx
  pop  ds
END;
{ PosCount ermittelt, wie oft SuchStr in QuellStr enthalten ist.
  Aber: wird z.B. 'DD' in 'DDDD' gesucht, dann meldet PosCount das
  dreimalige Vorkommen, denn DD ist an 3 Positionen vollstndig
  vorhanden (an Pos 1, 2, und 3). }


FUNCTION FirstPos (SuchStr, QuellStr : String) : Byte; assembler;
ASM
  push ds
  cld
  lds  si, SuchStr;  lodsw;             or  al, al; jz   @raus
  les  di, QuellStr; mov cl, es:[di];   xor ch, ch; jcxz @raus { Lnge Quelle}
  dec  al          { eins runter, da das erste Zeichen nicht von CMPSB
                     gesucht zu werden braucht (macht scasb) }
  xchg al, ah      { Lnge SuchStr in AH, erstes Zeichen in AL }
  inc  di          { Zeiger auf erstes Zeichen des zu durchsuchenden Strings }
  mov  bx, cx

  @nochmal:
  repne scasb
  jne   @raus      { nichts gefunden }
    push cx
    push si
    push di
    mov  cl, ah    { ch ist bereits 0 }
    repe cmpsb
    pop  di
    pop  si
    pop  cx
    jne  @nochmal
    sub  bx, cx
    mov  ax, bx
    jmp  @gefunden
  @raus:
  xor  ax, ax
  @gefunden:
  pop  ds
END;
{ entspricht POS }


FUNCTION LastPos (SuchStr, QuellStr : String) : Byte; assembler;
ASM
  push ds
  cld
  lds  si, SuchStr;  lodsb;             or  al, al; jz   @weg
  les  di, QuellStr; mov cl, es:[di];   xor ch, ch; jcxz @raus { Lnge Quelle}
  cmp  al, cl      { SuchStr lnger als Quelle ? }
  jbe  @los
    xor ax, ax
    jmp @weg
  @los:

  std              { rckwrts lesen }
  dec  al          { eins runter, da das letzte Zeichen nicht von CMPSB
                     geprft zu werden braucht (macht scasb) }
  xor  ah, ah
  add  si, ax
  mov  dx, ax      { Lnge SuchString in DX }
  lodsb            { Letztes Zeichen von SuchStr in AL laden }
  add  di, cx      { Zeiger auf letztes Zeichen des zu durchsuchenden Strings }

  @nochmal:
  repne scasb
  jne   @raus      { nichts gefunden }
    push cx
    push si
    push di
    mov  cl, dl    { ch ist bereits 0 }
    repe cmpsb
    pop  di
    pop  si
    pop  cx
    jne  @nochmal
    dec  dx        { Position des ersten Zeichens von SuchStr errechnen }
    sub  cx, dx
  @raus:
  mov  ax, cx
  @weg:
  pop  ds
  cld
END;
{ wie POS, ermittelt wird jedoch das letzte Vorkommen von SuchStr }


FUNCTION nthPos (SuchStr, QuellStr : String; Index : Word) : Byte; assembler;
ASM
  push ds
  cld
  lds  si, SuchStr;  lodsw;             or  al, al; jz   @raus
  les  di, QuellStr; mov cl, es:[di];   xor ch, ch; jcxz @raus { Lnge Quelle}
  dec  al          { eins runter, da das erste Zeichen nicht von CMPSB
                     gesucht zu werden braucht (macht scasb) }
  xchg al, ah      { Lnge SuchStr in AH, erstes Zeichen in AL }
  inc  di          { Zeiger auf erstes Zeichen des zu durchsuchenden Strings }
  mov  bx, cx
  mov  dx, Index
  or   dx, dx      { falls 0 eingegeben wurde }
  jnz  @nochmal
  inc  dx
  @nochmal:
  repne scasb
  jne   @raus      { nichts gefunden }
    push cx
    push si
    push di
    mov  cl, ah    { ch ist bereits 0 }
    repe cmpsb
    pop  di
    pop  si
    pop  cx
    jne  @nochmal
    dec  dx
    jnz  @nochmal
    sub  bx, cx
    mov  ax, bx
    jmp  @gefunden
  @raus:
  xor  ax, ax
  @gefunden:
  pop  ds
END;
{ wie Pos, wenn das Suchwort mehrmals in QuellStr vorkommt. Mit Index wird
  angegeben, von welchem der mehrmalig vorkommenen Suchstrings die Position
  ermittelt werden soll, z.B.:
  SuchStr:= 'das'; QuellStr:= 'dasdasdas'
  p:= nthPos (SuchStr, QuellStr, 2);
  In p befindet sich die Zahl 4, da das zweite Vorkommen von 'das' an
  Position 4 beginnt. }


FUNCTION Trim (OrigStr : String) : String; assembler;
ASM
  push ds
  les  di, OrigStr
  mov  cl, es:[di]; xor ch, ch; jcxz @null
  push di
  add  di, cx
  mov  al, ' '
  std
  repe scasb
  pop  di
  cld
  je   @null
  inc  di
  inc  cx
  repe scasb
  dec  di
  mov  si, di
  push es
  pop  ds
  inc  cx
  @null:
  les  di, @Result
  mov  al, cl
  stosb
  rep  movsb
  pop  ds
END;
{ entfernt alle fhrenden und anhngenden Leerzeichen aus einem String }


FUNCTION InStr (Start : Byte; OrigStr, SeekStr : String) : Byte; assembler;
ASM
  push ds
  cld
  lds  si, SeekStr; lodsw;             or  al, al; jz   @raus
  les  di, OrigStr; mov cl, es:[di];   xor ch, ch; jcxz @raus { Lnge OrigStr}

  mov  dl, Start; or dl, dl; jz @dontdec; dec dl; @dontdec: xor dh, dh
  cmp  dx, cx      { Suchposition hinter String-Ende? }
  jae  @raus

  dec  al          { eins runter, da das erste Zeichen nicht von CMPSB
                     gesucht zu werden braucht (macht scasb) }
  xchg al, ah      { Lnge SeekStr in AH, erstes Zeichen in AL }
  inc  di          { Zeiger auf erstes Zeichen des zu durchsuchenden Strings }
  add  di, dx
  mov  bx, cx
  sub  cx, dx

  @nochmal:
  repne scasb
  jne   @raus      { nichts gefunden }
    push cx
    push si
    push di
    mov  cl, ah    { ch ist bereits 0 }
    repe cmpsb
    pop  di
    pop  si
    pop  cx
    jne  @nochmal
    sub  bx, cx
    mov  ax, bx
    jmp  @gefunden
  @raus:
  xor  ax, ax
  @gefunden:
  pop  ds
END;
{ ermittelt die Position von "SeekStr" innerhalb von "OrigStr". Gesucht
  wird hierbei ab Position "Start". Das Ergebnis ist jedoch die
  Position gemessen vom String-Anfang: InStr (3, 'andre an der wand', 'an')
  wrde 7 zurckgeben (also die Position des Wrtchens "an"). Als "Start"
  kann auch 1 oder 0 verwendet werden, in diesem Falle ist das Ergebnis
  identisch mit dem von Pascal-"pos" }


FUNCTION LastInStr (Start : Byte; OrigStr, SeekStr : String) : Byte;
VAR
  p : Byte;
BEGIN
  p:= LastPos (SeekStr, OrigStr);
  If p<Start Then LastInStr:= 0 Else LastInStr:= p;
END;
{ wie LastStr, nur wird das letzte Vorkommen zurckgegeben. }


FUNCTION ReplaceAll (OrigStr, SeekStr, ErsatzStr : String) : String;
VAR
  p : Byte;
BEGIN
  If Length (SeekStr)<>0 Then
  BEGIN
    p:= InStr (1, OrigStr, SeekStr);
    While p<>0 Do
    BEGIN
      delete (OrigStr, p, Length (SeekStr));
      insert (ErsatzStr, OrigStr, p);
      p:= InStr (p+Length(ErsatzStr), OrigStr, SeekStr);
    END;
  END;
  ReplaceAll:= OrigStr;
END;
{ Ersetzt innerhalb "OrigStr" alle Vorkommen von "SeekStr" durch "Ersatzstr".
  Ist "ErsatzStr" ein leerer String, werden alle Vorkommen von "SeekStr"
  entfernt. }


FUNCTION CountFields (OrigStr : String; Separator : Char) : Byte; assembler;
ASM
  xor bx, bx
  cld
  les di, OrigStr
  mov cl, es:[di]; xor ch, ch; jcxz @raus
  mov al, Separator
  inc di
  @nochmal:
    repne scasb
    jne @raus
    inc bx
  jmp @nochmal
  @raus:
  mov ax, bx
  inc ax
END;
{ ermittelt die Anzahl der durch das "Separator"-Zeichen voneinander
  getrennten Teile des "OrigStr". Wird als "Separator" z.B. ein
  Leerzeichen angegeben, ermittelt "CountFields" die Zahl der Wrter in
  einem String - wird ; oder #9 (Tabulator) angegeben, kann die Zahl der
  Datenfelder in einem CSV-String ermittelt werden. }


FUNCTION nthField (OrigStr : String; Separator : Char; n : Byte) : String; assembler;
ASM
  push ds
  cld
  xor  dl, dl { Zhler fr die Stringlnge des Funktionsergebnisses }
  les  di, @Result; push di; inc di
  lds  si, OrigStr; lodsb; mov cl, al; xor ch, ch; jcxz @ende
  mov  bl, 1  { Vergleichs-Wert zu "n" }
  mov  bh, n
  mov  ah, Separator
  @next:
    lodsb
    cmp al, ah
    je  @incBL
    cmp bl, bh
    je  @storeAL
  loop @next
  jmp @ende
  @storeAL:
    stosb
    inc dl
  loop @next
  jmp @ende
  @incBL:
    cmp bl, bh
    je  @ende
    inc bl
  loop @next
  @ende:
  pop  di
  mov  al, dl
  stosb
  pop  ds
END;
{ liefert das "n"-te durch den "Separator" abgetrennte Feld zurck. Wird
  z.B. als "Separator" ein Leerzeichen angegeben, kann ein Satz in seine
  einzelnen Wrter zerlegt werden, wird ein ; oder #9 (Tabulator) angegeben,
  kann ein CSV-String in seine einzelnen Felder zerlegt werden. Existiert
  das "n"-te Feld nicht, wird ein Leerstring zurckgegeben.

  CONST
    s : String = 'Dies ist ein Test';
  VAR
    x : Byte;
  BEGIN
    For x:= 1 To CountFields (s, ' ') Do WriteLn (nthField (s, ' ', x));
  END;

  Weiteres Anwendungsgebiet: Zerlegen eines Pfadnamens in die einzelnen
  Verzeichnisebenen ('\' als "Separator" angeben).
}


FUNCTION FromNthField (OrigStr : String; Separator : Char; n : Byte) : String; assembler;
ASM
  push ds
  cld
  les  di, @Result; push di; inc di
  lds  si, OrigStr; lodsb; mov cl, al; xor ch, ch; jcxz @ende
  mov  bl, 1   { Vergleichs-Wert zu "n" }
  mov  bh, n
  or   bh, bh  { if n=0 then n:= 1 }
  jnz  @los
  inc  bh
  @los:
  cmp  bl, bh  { = wenn bl=1, dann gleich den gesamten String holen }
  je   @ready
  inc  bl
  xor  dl, dl  { Zhler fr die Stringlnge des Funktionsergebnisses }
  mov  ah, Separator
  @next:
    lodsb
    cmp al, ah
    je  @incBL
  loop @next
  jmp @ende
  @storeAL:
    dec cl
  @ready:
    mov dl, cl
    rep movsb
    jmp @ende
  @incBL:
    cmp bl, bh
    jae @StoreAL
    inc bl
  loop @next
  @ende:
  pop  di
  mov  al, dl
  stosb
  pop  ds
END;
{ wie nthField, es wird jedoch der gesamte Rest-String inklusive des
  n-ten Feldes zurckgegeben - alle weiteren Separatoren werden dabei
  als normale Zeichen betrachtet (also auch unmittelbar
  aufeinanderfolgende) }


FUNCTION ChangeField (OrigStr : String; Separator : Char; n : Byte; NewStr : String) : String; assembler;
ASM
  push ds
  cld
  xor  dx, dx   { Zhler fr die Stringlnge des Funktionsergebnisses }
  les  di, @Result; push di; inc di
  lds  si, OrigStr; lodsb; mov cl, al; xor ch, ch; jcxz @raus
  mov  bl, 1    { Vergleichs-Wert zu "n" }
  mov  bh, n
  mov  ah, Separator
  @next:
    cmp bl, bh
    je  @GetNewStr
    lodsb
    cmp al, ah
    jne @weiter
      inc bl
    @weiter:
    stosb
    cmp dx, 255
    jae @raus
    inc dx
  loop @next
  cmp  bl, bh
  jne  @raus
  @GetNewStr:
    inc  cx
    push ds
    push si
    push cx
    lds  si, NewStr; lodsb; mov cl, al; xor ch, ch; jcxz @fertig
    add  dx, cx
    or   dh, dh
    jz @InsNewStr
      sub cl, dl
      dec cx
      mov dx, 255
  @InsNewStr:
    rep  movsb
    inc  bl      { als Flag, da NewStr jetzt eingefgt wurde }
  @fertig:
    pop  cx
    pop  si
    pop  ds
    jcxz @raus
    @NextSeek:   { Im OrigStr bis zum nchsten Separator lesen }
      lodsb
      cmp al, ah
    loopne @NextSeek
    jcxz @raus
    jmp @weiter
  @raus:
  pop  di
  mov  al, dl
  stosb
  pop  ds
END;
{ ersetzt das "n"-te durch den "Separator" abgetrennte Feld in "OrigStr"
  durch "NewStr". Achtung: Wrde die resultierende Zeichenkette durch
  das Austauschen eines Feldes lnger als 255 Zeichen werden, gehen alle
  berzhligen Zeichen am Ende von "OrigStr" verloren - es knnen also auch
  ganze Felder verlorengehen. Dies entspricht dem Verhalten von
  Pascal-"insert".

  Ist "n" grer als die Zahl der vorhandenen Felder, so wird der
  "OrigStr" unverndert zurckgegeben.
}



FUNCTION UpChar (Cha : Char) : Char; assembler;
ASM
  mov al, cha
  cmp al, 'a'; jb  @Ende
  cmp al, 'z'; ja  @a
  sub al, 32;  jmp @Ende
 @a: cmp al, ''; jne @b;    mov al, ''; jmp @Ende
 @b: cmp al, ''; jne @c;    mov al, ''; jmp @Ende
 @c: cmp al, ''; jne @Ende; mov al, ''; 
 @Ende:
END;


FUNCTION LowChar (Cha : Char) : Char; assembler;
ASM
  mov al, cha
  cmp al, 'A'; jb  @Ende
  cmp al, 'Z'; ja  @a
  add al, 32;  jmp @Ende
 @a: cmp al, ''; jne @b;    mov al, ''; jmp @Ende
 @b: cmp al, ''; jne @c;    mov al, ''; jmp @Ende
 @c: cmp al, ''; jne @Ende; mov al, ''; 
 @Ende:
END;


FUNCTION UpStr (s : String) : String; assembler;
ASM
  mov bx, ds; cld; lds si, s;  les di, @Result
  lodsb; stosb; xor ah, ah; mov cx, ax; jcxz @Ende
 @Start:
  lodsb
  cmp al, 'a'; jb  @1
  cmp al, 'z'; ja  @a
  sub al, 32; stosb; loop @Start; jmp @Ende
 @a: cmp al, ''; jne @b; mov al, '';     Stosb; loop @Start; jmp @Ende
 @b: cmp al, ''; jne @c; mov al, '';     Stosb; loop @Start; jmp @Ende
 @c: cmp al, ''; jne @1; mov al, ''; @1: stosb; loop @Start;
 @Ende:
  mov ds, bx
END;
{Verwandelt alle Zeichen eines Strings in Grobuchstaben}


FUNCTION LowStr (s : String) : String; assembler;
ASM
  mov bx, ds; cld; lds si, s;  les di, @Result
  lodsb; stosb; xor ah, ah; mov cx, ax; jcxz @Ende
 @Start:
  lodsb
  cmp al, 'A'; jb  @1
  cmp al, 'Z'; ja  @a
  add al,  32; stosb; loop @Start; jmp @Ende
 @a: cmp al, ''; jb @1; jne @b; mov al, ''; stosb; loop @Start; jmp @Ende
 @b: cmp al, '';        jne @c; mov al, ''; stosb; loop @Start; jmp @Ende
 @c: cmp al, '';        jne @1; mov al, '';
 @1:
  stosb
  loop @Start
 @Ende:
  mov ds, bx
END;
{Verwandelt alle Zeichen eines Strings in Kleinbuchstaben}



PROCEDURE StretchParam (VAR TempBuf : String); assembler;
ASM
  cld
  xor  dl, dl
  push ds
  mov  ds, PrefixSeg
  mov  si, 80h
  les  di, TempBuf
  lodsb
  xor  cx, cx
  mov  cl, al
  jcxz @ende
  mov  bx, di
  stosb

  mov al, 32                       {falls erstes Zeichen = /}
  @nochmal:
    mov  ah, al
    lodsb
    cmp  al, '/'; jne @weiter
    cmp  ah, ' '; je  @weiter
    mov  Byte Ptr es:[di], 32      {Leerzeichen einfgen}
    inc  di
    @weiter:
    stosb
  loop @nochmal

  sub  di, bx
  cmp  di, 128         {pat TempBuf in Komandozeilenpuffer ?}
  ja   @ende  

  mov  cx, di
  dec  di
  mov  ax, di
  mov  es:[bx], al     {LngenByte in TempBuf schreiben }

  mov  ax, ds
  mov  es, ax          {Prefixseg}
  mov  di, 80h
  lds  si, TempBuf
  rep  movsb           {zurckkopieren}

  @ende:                                    
  pop ds
END;
{ macht aus Parameter "/s/e/b" -> "/s /e /b". Kann dann mit ParamStr()
  ganz normal gelesen werden. Sollte ganz am Anfang des Programmes
  aufgerufen werden. (Der String "TempBuf" wird nur als Zwischenspeicher
  fr die Operation bentigt und enthlt anschlieend die gesamte
  (gestreckte) Kommandozeile.) }


FUNCTION CmdLine : String; assembler;
VAR
  Dummy : Byte;  { mu sein, sonst funktioniert's nicht (Pascal-Bug) }
ASM
  cld
  push ds
  mov  ds, Prefixseg
  mov  si, 80h
  les  di, @Result
  lodsb
  stosb
  mov  cl, al
  xor  ch, ch
  rep  movsb
  pop  ds
END;
{ liefert die gesamte Kommandozeile zurck, also alle ParamStr(x) }




FUNCTION IsPlus (Path : String) : Boolean; assembler;
ASM
  push ds
  lds  si, Path
  xor  cx, cx
  mov  cl, [si]
  jcxz @false
  add  si, cx
  std
  @loop:
    lodsb
    cmp al, '+'
    je  @true
    cmp al, '\'
    je  @false
    cmp al, ':'
  loopne @loop
  @false:
    mov al, FALSE
    jmp @raus
  @true:
    mov al, TRUE
  @raus:
  cld
  pop ds
END;


FUNCTION GetPathName (Path : String) : String; assembler;
ASM
  les di, Path
  xor cx, cx
  mov cl, es:[di]
  add di, cx
  inc cx
  std
  mov ax, ':\'
  @loop:
    cmp es:[di], ah
    je  @copy
    scasb
    @copy:
  loopne @loop
  jcxz @notDelSlash
  cmp Byte Ptr es:[di], ':'; je @notDelSlash; dec cx;
  @notDelSlash:
  cld
  push ds
  lds si, Path
  inc si
  les di, @Result
  mov al, cl
  stosb
  rep movsb
  pop ds
END;
{ Gibt von einem Dateipfad den Verzeichnisanteil zurck (z.B. c:\tp
  von c:\tp\pascal). Ist das Resultat ein Verweis auf das Wurzelverzeichnis,
  bleibt das letzte Backslash am Pfad-Ende erhalten (c:\) }


FUNCTION GetFileName (Path : String) : String; assembler;
ASM
  push ds
  lds si, Path
  xor cx, cx
  mov cl, [si]
  add si, cx
  mov bx, cx
  inc cx
  std
  mov dx, ':\'
  @loop:
    lodsb
    cmp al, dl
    je  @copy
    cmp al, dh
    @copy:
  loopne @loop
  cld
  inc si
  inc si
  les di, @Result
  sub bx, cx
  mov cx, bx
  mov al, cl
  stosb
  rep movsb
  pop ds
END;
{ Gibt von einem Dateipfad den bzw. die Dateinamen zurck. Ein Krzen
  auf 12 Zeichen erfolgt nicht, um auch eine Liste von
  Datei-Masken (*.txt+*.doc+*.tmp) zurckgeben zu knnen. }


FUNCTION GetFileExt (Path : String) : String; assembler;
ASM
  push ds
  lds si, Path
  xor cx, cx
  mov cl, [si]
  add si, cx
  mov bx, cx
  inc cx
  std
  mov dx, ':\'
  @loop:
    lodsb
    cmp al, dl
    je  @copy
    cmp al, dh
    @copy:
  loopne @loop
  cld
  sub bx, cx
  mov cx, bx
  inc cx
  inc si
  mov ah, '.'
  @loop2:
    lodsb
    cmp al, ah
  loopne @loop2
  les di, @Result
  cmp cx, 3
  jbe @los
  mov cx, 3
  @los:
  mov al, cl
  stosb
  rep movsb
  pop ds
END;
{ Gibt von einem Dateipfad die Dateiendung zurck (z.B. pas
  von c:\tp\pascal.pas). Das Funktionsergebnis ist auch bei kuriosen
  (xy.z\te oder c:..) Pfaden mit dem Ergebnis von FSplit identisch,
  allerdings wird der fhrende Punkt nicht mit ausgegeben.
  Ergebnisse lnger als 3 Zeichen werden abgeschnitten. }


FUNCTION GetFilePrefix (Path : String) : String;
BEGIN
  GetFilePrefix:= nthField (GetFileName (Path), '.', 1);
END;


FUNCTION ChangeFileExt (Path : String; NewExt : Str3) : String;
VAR
  p : Byte;
BEGIN
  p:=LastPos ('.', Path);
  If LastPos ('\', Path) > p Then p:= 0;
  If p<>0 Then Path[0]:= chr (pred(p));
  ChangeFileExt:= Path + '.' + NewExt;
END;
{ Tauscht die Dateiendung gegen "NewExt" bzw. hngt "NewExt" an den
  Dateinamen an, wenn dieser keine Endung trgt
  ChangeFileExt ('C:\TEST.TXT', 'DOC') -> C:\TEST.DOC }


FUNCTION BuildPath (Pfad, Datei: String) : String; assembler;
ASM
  push ds; cld; les di, @Result; mov dh, '\';
  lds si, Pfad;
  lodsb; stosb; mov dl, al; xor ah, ah; mov cx, ax; jcxz @1
  rep movsB;
  dec si; lodsB; cmp al, dh; je @1; cmp al, ':'; je @1
  mov al, dh; stosb; inc dl;
@1:
  lds si, Datei;
  lodsW; mov bx, ax; xor ah, ah; mov cx, ax; jcxz @2
  cmp bh, dh; jne @3; dec cx; dec bl; jmp @4;
@3:
  dec si
@4:
  rep movsb;
  add dl, bl; mov al, dl; les di, @Result; stosb;
@2:
  pop ds
END;
{ Verbindet Pfad- und Dateinamen zu einem vollstndigen Pfadnamen }


FUNCTION ShrinkPath (x : Byte; Path : String) : String;
BEGIN
  If Length (Path) > x+3 Then
  BEGIN Delete (Path, 4, Length (Path)-x); Insert ('...', Path, 4); END;
  ShrinkPath:= Path;
END;
{ krzt berlange Pfadnamen auf die Lnge x und fgt '...' ein. Ist der
  Pfad vorher schon krzer als x, wird er unverndert zurckgegeben. }


FUNCTION DelLastSlash (Path : String) : String;
BEGIN
  If  (Path[Length(Path)]='\')
  and ((Length(Path)>3) or (pos(':', Path)<>2)) Then
  dec (Path[0]);
  DelLastSlash:= Path;
END;


FUNCTION LZ (w : Word) : String; assembler;
ASM
  cld
  les di, @result
  mov al, 2
  stosb
  xor dx, dx
  mov ax, w
  mov bx, 10
  div bx
  mov ah, dl
  or  ax, 3030h
  stosw
END;
{ LeadingZero: verwandelt zweistellige Zahlen in Strings mit
  fhrender Null (z.B.Uhr)}


FUNCTION LS (w : Word) : String; assembler;
ASM
  cld
  les di, @result
  mov al, 2
  stosb
  xor dx, dx
  mov ax, w
  mov bx, 10
  div bx
  mov ah, dl
  or  ax, 3030h
  cmp al, '0'
  jne @los
  mov al, ' '
  @los:
  stosw
END;
{ LeadingSpace: verwandelt zweistellige Zahlen in Strings mit
  fhrendem Leerzeichen }


FUNCTION IntVal (s : String) : LongInt;
VAR
  l : LongInt;
  c : Integer;
BEGIN
  Val (s, l, c);
  If c<>0 Then Val (copy (s, 1, pred(c)), l, c);
  IntVal:= l;
END;   
{ Wandelt einen String in eine Binrzahl um. Enthlt "s" Buchstaben
  o.., wird nur der erste Teil von "s" ausgewertet, der Ziffern enthlt }


FUNCTION StrVal (x : LongInt) : String;
VAR
  s : String[12];
BEGIN
  Str (x, s);
  StrVal:= s;
END;

(* in ASM einbauen, ansonsten verwerfen, da Pascal-Str weniger Code erzeugt *)
(*
FUNCTION StrVal1 (x : LongInt) : String; Assembler;
ASM
  les  di, @Result
  inc  di                  {Lngenbyte berspringen}
  mov  bx, word (x)
  mov  ax, word (x+2);
  test ah, 10000000b       {negative Zahl ?}
  jz   @weiter
    neg bx
    not ax
  @weiter:
  mov  si, 10
  xor  cx, cx              {zhlt die Stellen}
  @nochmal:
    xor  dx, dx
    div  si
    xchg bx, ax
    div  si
    xchg ax, bx
    add  dl, 48           {Rest in DX, umwandeln in ASCII-Ziffer}
    mov  es:[di], dl      {in String schreiben}
    inc  di
    inc  cx
  or  ax, ax              {ax und bx prfen, ob schon Null}
  jnz @nochmal
  or  bx, bx
  jnz @nochmal
  test byte (x+3), 10000000b
  jz @los
    mov al, '-'
    stosb
    inc cx
  @los:
  cld                     {Zeichenkette swappen}
  les  di, @Result
  mov  si, di
  add  si, cx             {si=Zeiger auf letztes Zeichen}
  mov  al, cl             {Lngenbyte schreiben}
  stosb                   {di=Zeiger auf erstes Zeichen}
  shr  cx, 1              {Stringlnge durch 2}
  jcxz @raus
  @swap:
    mov  al, es:[di]      {Zeichen austauschen}
    xchg al, es:[si]
    stosb
    dec  si
  loop @swap
  @raus:
END;
*)
{ Verwandelt eine ganze Binrzahl in einen String (hnlich Pascal-"Str") }


FUNCTION TPkt (s : String) : String; assembler;
ASM
  push ds
  cld
  lds si, s; les di, @Result; mov bx, di
  lodsb; stosb; mov cl, al; xor ch, ch; jcxz @ende
  mov dl, cl; mov al, '.'
  @start:
    movsb
    cmp cl,  4; je  @punkt
    cmp cl,  7; je  @punkt
    cmp cl, 10; jne @weiter
    @punkt:
    stosb
    inc dl
    @weiter:
  loop @start
  mov byte ptr es:[bx], dl
  @ende:
  pop ds
END;
{ fgt in eine als String vorliegende Zahl die Tausender-Punkte ein }


FUNCTION TausPkt (x : LongInt) : String;
BEGIN
  TausPkt:= TPkt (StrVal (x));
END;
{ Verwandelt eine Binr-Zahl in eine Zeichenkette mit Tausender-Punkten }


FUNCTION FillString (Len : Byte) : String; assembler;
ASM
  cld
  mov al, Len
  les di, @result
  stosb
  mov cl, al
  xor ch, ch
  mov al, 32
  rep stosb
END;
{ Erzeugt einen mit Leerzeichen gefllten String der Lnge "Len".
  Geeignet zum Einrcken von Zeichenketten auf Monitor und Drucker }


FUNCTION StretchRight (ein : String; Len : Word) : String; assembler;
ASM
  push ds
  cld
  lds  si, ein; lodsb; xor ah, ah; mov cx, ax;
  les  di, @Result; mov bx, di; stosb
  rep  movsb
  mov  cx, Len
  cmp  cx, ax
  jbe  @ende
    mov dx, cx
    sub cx, ax
    mov al, ' '
    rep stosb
    mov es:[bx], dl
  @ende:
  pop ds
END;
{ Streckt einen String durch Anhngen von Leerzeichen auf die Lnge "Len" }


FUNCTION StretchLeft (ein : String; Len : Word) : String; assembler;
ASM
  push ds
  cld
  lds  si, ein; lodsb; xor ah, ah; mov cx, ax; mov dx, Len
  les  di, @Result;
  cmp  cx, dx
  jae  @los
    mov  al, dl
    stosb
    sub  dx, cx
    xchg cx, dx
    mov  al, ' '
    rep  stosb
    xchg cx, dx
    jmp  @copy
  @los:
  stosb
  @copy:
  rep  movsb
  pop  ds
END;
{ Streckt einen String durch Voranstellen von Leerzeichen auf die Lnge "Len" }


FUNCTION BreakLine (s : String; MaxLen : Byte) : String;
VAR
  x, p     : Byte;
  res, tmp : String;
BEGIN
  res:= '';
  tmp:= '';
  For x:= 1 To Length(s) Do
  BEGIN
    Insert (s[x], tmp, 255);
    If (Length(tmp) >= MaxLen) and (x<Length(s)) and (s[x+1]<>' ') Then
    BEGIN
      p:= LastPos (' ', tmp);
      If p=0 Then p:= Length (tmp)+1;
      Insert (copy (tmp, 1, p-1)+#13#10, res, 255);
      delete (tmp, 1, p);
    END;
  END;
  Insert (tmp, res, 255);
  BreakLine:= res;
END;
{ bricht eine Zeile an Position "MaxLen" um }


FUNCTION ASCIIZtoPascal (VAR ein) : String; assembler;
ASM
  cld
  push ds
  lds  si, ein
  les  di, @result
  push di
  inc  di
  xor  bx, bx
  @nochmal:
    lodsb
    or  al, al
    jz  @ende
    stosb
    inc bx
    cmp bx, 255
    jae @ende
  jmp @nochmal
  @ende:
  pop  di
  mov  ax, bx
  stosb
  pop  ds
END;


PROCEDURE PascalToASCIIZ (ein : String; VAR aus; OutBufSize : Byte); assembler;
ASM
  cld
  push ds
  les  di, aus
  lds  si, ein
  lodsb
  xor  ah, ah
  mov  cx, ax
  jcxz @ende
  mov  al, OutBufSize
  xor  ah, ah
  dec  ax
  cmp  cx, ax
  jbe  @weiter
  mov  cx, ax
  @weiter:
  rep  movsb
  @ende:
  xor  al, al
  stosb
  pop  ds
END;

{ das folgende noch verbessern ! }
FUNCTION SameFile (p1, p2 : PathStr) : Boolean;
VAR
  f1, f2 : File;
  a1, a2 : Word;
  o1     : Word;
BEGIN
  Assign (f1, p1); GetFAttr (f1, a1);
  Assign (f2, p2); GetFAttr (f2, a2);
  If a1=a2 Then
  BEGIN
    o1:= a1;
    If a1=0 Then a1:= 32 Else a1:= 0;
    SetFAttr (f1, a1);
    GetFAttr (f2, a2);
    SetFAttr (f1, o1);
  END;
  SameFile:= a1=a2;
END;
{ Erkennt, ob Datei in einem SUBST-Laufwerk mit einer anderen Datei
  physikalisch identisch ist (wenn z.B. das als Subst-Laufwerk gesetzte
  Verzeichnis geffnet wurde }

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
