UNIT TextTool;

{ Ermglicht in Text-Dateien (Pascal-Dateityp "Text") die Verwendung von
  FileSize, FilePos und Seek sowie das vorausschauende Lesen des nchsten
  Zeichens, ohne dieses abzuholen. }

INTERFACE

USES
  DOS;

FUNCTION  NextChar     (VAR f : Text) : Char;
FUNCTION  TextFileSize (VAR f : Text) : LongInt;
FUNCTION  TextFilePos  (VAR f : Text) : LongInt;
PROCEDURE TextSeek     (VAR f : Text; NewPos : LongInt);

IMPLEMENTATION


FUNCTION NextChar (VAR f : Text) : Char;
VAR
  c : Char;
BEGIN
  Read (f, c);
  With TextRec(f) Do If BufPos>0 Then dec (BufPos);
  NextChar:= c;
END;
{ liest das nchste Zeichen aus einer Textdatei, ohne es "abzuholen", d.h.,
  der nchste Aufruf von Read (f, Char) wrde genau dieses Zeichen liefern.
  Wird NextChar nach dem Erreichen des Dateiendes (Eof(f)=TRUE) aufgerufen,
  liefert es ASCII-26, also die Datei-Ende-Marke (die jedoch nicht in jedem
  Falle tatschlich in der Datei enthalten ist!) }


FUNCTION TextFileSize (VAR f : Text) : LongInt; assembler;
ASM
  cmp  word ptr InOutRes, 0
  jne  @ende
  les  di, f

  mov  bx, es:[di+TextRec.Mode]
  mov  ax, 102       { Fehler 102: Assign noch nicht aufgerufen }
  or   bx, bx        { Prfen, ob Datei "assigned" ist }
  jz   @error
  inc  ax            { Fehler 103: Datei nicht offen }
  cmp  bx, fmClosed  { Prfen, ob Datei geffnet ist }
  je   @error

  mov  bx, es:[di]   { Datei-Handle }
  mov  ax, 4201h     { Dateizeiger um 0 Byte bewegen -> akt. Dateiposition }
  xor  cx, cx
  xor  dx, dx
  int  21h
  jc   @error
  push ax            { aktuelle Dateiposition merken }
  push dx

  xor  cx, cx
  xor  dx, dx
  mov  ax, 4202h     { Dateizeiger 0 Byte vor (also AN) das Dateiende setzen }
  int  21h
  mov  di, ax        { Dateigre (DX:AX) merken }
  mov  si, dx
  pop  cx            { alte Datei-Position in CX:DX laden }
  pop  dx
  jc   @error        { Fehler erst hier abfragen ! }

  mov  ax, 4200h     { alte Dateiposition wieder herstellen }
  int  21h
  jc   @error

  mov  ax, di        { Dateigre in Funktions-"Output" kopieren }
  mov  dx, si

  mov  cx, es:[di+TextRec.Mode]
  cmp  cx, fmOutPut  { Wenn die Datei zum Schreiben geffnet ist, mu die }
  jne  @ende         { Zahl der Zeichen im Cache-Puffer hinzuaddiert werden }
  add  ax, es:[di+TextRec.BufPos]
  adc  dx, 0         
  jmp  @ende

  @error:
  mov  InOutRes, ax  { Fehler mit IOResult abfragen }
  xor  ax, ax        { 0 als Dateigre ausgeben }
  xor  dx, dx
  @ende:
END;
{ Ermittelt wie Pascal-"FileSize" die Gre der Textdatei. Ist die Textdatei
  zum Schreiben geffnet, wird die Gre zurckgegeben, die die Datei htte,
  wenn sie unmittelbar danach mit "Close" geschlossen wrde - es werden also
  die momentan im Schreib-Cache befindlichen Zeichen mitgerechnet. }


FUNCTION TextFilePos (VAR f : Text) : LongInt; assembler;
ASM
  cmp  word ptr InOutRes, 0
  jne  @raus
  les  di, f

  mov  bx, es:[di+TextRec.Mode]
  mov  ax, 102             { Fehler 102: Assign noch nicht aufgerufen }
  or   bx, bx              { Prfen, ob Datei "assigned" ist }
  jz   @error
  inc  ax                  { Fehler 103: Datei nicht offen }
  cmp  bx, fmClosed        { Prfen, ob Datei geffnet ist }
  je   @error

  mov  bx, es:[di]         { Datei-Handle }
  mov  ax, 4201h           { Relativ zur aktuellen Position }
  xor  cx, cx              { um 0 Bytes bewegen }
  xor  dx, dx
  int  21h                 { Dateiposition in DX:AX }
  jc   @error
    mov cx, es:[di+TextRec.Mode]
    cmp cx, fmOutPut       { je nachdem, ob die Datei zum Lesen oder Schreiben }
    je  @out               { geffnet ist, mu anderes gerechnet werden }
      mov bx, es:[di+TextRec.BufEnd]
      sub bx, es:[di+TextRec.BufPos]
      sub ax, bx
      sbb dx, 0            { Zahl der Zeichen im Cache-Puffer abziehen, da }
      jmp @raus            { Read/ReadLn mind. 128 Zeichen im Voraus liest }
    @out:
      add ax, es:[di+TextRec.BufPos]
      adc dx, 0            { Zahl der Zeichen im Cache-Puffer hinzuaddieren }
      jmp @raus
  @error:
  mov  InOutRes, ax
  xor  dx, dx
  xor  ax, ax
  @raus:
END;
{ Ermittelt wie Pascal-"Filepos" die aktuelle Position in der Textdatei. Die
  Zahl der Zeichen im Schreib-/Lese-Cache wird dabei bercksichtigt.
  Anm.: Liefert auch beim Schreiben zu DOS-Gerten (CON, NUL etc.) korrekte
  Werte, knnte also z.B. nach umfangreichen Bildschirmausgaben zum Zhlen
  der ausgegebenen Zeichen verwendet werden und entspricht quasi der
  "Dateigre". }


PROCEDURE TextSeek (VAR f : Text; NewPos : LongInt); assembler;
ASM
  cmp  word ptr InOutRes, 0
  jne  @raus
  les  di, f

  mov  bx, es:[di+TextRec.Mode]
  mov  ax, 102       { Fehler 102: Assign noch nicht aufgerufen }
  or   bx, bx        { Prfen, ob Datei "assigned" ist }
  jz   @error
  inc  ax            { Fehler 103: Datei nicht offen }
  cmp  bx, fmClosed  { Prfen, ob Datei geffnet ist }
  je   @error
  inc  ax            { Fehler 104: Datei nicht zum Lesen geffnet }
  cmp  bx, fmInput   { Prfen, ob Datei zum Lesen geffnet wurde }
  jne  @error

  mov  cx, word ptr [NewPos+2]
  mov  dx, word ptr [NewPos]
  mov  bx, es:[di]   { Datei-Handle }
  mov  ax, 4200h     { al=00: Rel zum Dateianfang, 1: Akt.Pos, 2: Rel.zum Dateiende }
  int  21h
  jc   @error

  mov bx, es:[di+TextRec.BufEnd] { Cache-Zeiger aufs letzte Zeichen setzen, }
  mov es:[di+TextRec.BufPos], bx { um Neulesen des Puffers zu erzwingen - der }
  jmp @raus                      { Inhalt des Caches wird also verworfen }

  @error:
  mov InOutRes, ax
  @raus:
END;
{ Setzt den Datei-Zeiger wie Pascal-"Seek" auf eine neue Position. Kann nur
  verwendet werden, wenn die Datei zum Lesen geffnet ist. Vorsicht: Der
  Lesezeiger lt sich anders als bei Pascal-"Seek" auch hinter das Datei-
  Ende setzen (unter DOS legal!). Pascal-"Eof(f)" liefert dann sofort TRUE.
  Um den Lesezeiger korrekt an (oder vor) das Datei-Ende zu setzen, mu
  der Befehl lauten: TextSeek (f, TextFileSize(f)-x); (x:=0 -> Dateiende).

  Anm.: Das Versetzen des Dateizeigers in einer zum Schreiben geffneten
  Datei wrde funktionieren, wenn die Datei mit Pascal-"Append" geffnet
  wrde UND noch kein Zeichen geschrieben worden ist - dann liee sich der
  Dateizeiger zurckversetzen und dort der (ber-)Schreibvorgang starten.
  Dazu mten dann die drei Zeilen ab einschl. "Fehler 104" entfernt werden.

  Das Problem nach erfolgtem Schreiben sind die Zeichen im Schreib-Cache -
  Entweder Pascal-"TextRec.FlushFunc" oder der DOS-Puffer-Flush arbeiten
  anscheinend nur korrekt, wenn die Datei mit "Close" geschlossen wird.
}


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
