UNIT Time;

INTERFACE
USES
  Strings, DOS;

VAR
  DayOfWeek  : Byte;

TYPE
  TimeString = String[10];
  DosTimeRec = RECORD mi, ho, hu, se : Byte; END;
  DosDateRec = RECORD DayOfWeek, Day, Month : Byte; Year : Word; END;


PROCEDURE GetDosTime (VAR TRec : DosTimeRec);
PROCEDURE GetDosDate (VAR DRec : DosDateRec);
PROCEDURE SetDosDate (DRec : DosDateRec);
PROCEDURE SetDosTime (TRec : DosTimeRec);

FUNCTION  ActTimeStr (Leng : Byte)  : TimeString;
FUNCTION  ActDateStr (Leng : Byte)  : TimeString;
FUNCTION  LeapYear   (Jahr : Word ) : Boolean; 
FUNCTION  WeekDay    (Tag, Monat    : Byte; Jahr : Word) : Byte;
FUNCTION  MonthLen   (Month, Year : Word) : Byte;
FUNCTION  ParseDate  (DateStr : String)  : LongInt;
FUNCTION  GetRelDate (DayDiff : Integer) : LongInt;

FUNCTION  SysTime : LongInt;
PROCEDURE XDelay (t : Word);
FUNCTION  Seconds : LongInt;
PROCEDURE StartTime;
FUNCTION  EndTime : LongInt;


IMPLEMENTATION

VAR
  StartSysTime : LongInt;
  

PROCEDURE GetDosTime (VAR TRec : DosTimeRec); Assembler;
ASM
  mov ah, 2Ch
  int 21h
  cld
  les di, TRec
  mov ax, cx
  StosW
  mov ax, dx
  StosW
END;


PROCEDURE GetDosDate (VAR DRec : DosDateRec); Assembler;
ASM
  mov ah, 2Ah
  int 21h
  cld
  les di, DRec
  stosB
  mov ax, dx
  stosW
  mov ax, cx
  stosW
END;


PROCEDURE SetDosTime (TRec : DosTimeRec); assembler;
ASM
  mov cx, Word Ptr TRec.mi
  mov dx, Word Ptr TRec.hu
  mov ah, 2Dh
  int 21h
END;


PROCEDURE SetDosDate (DRec : DosDateRec); assembler;
ASM
  mov bx, ds
  lds si, DRec
  inc si
  LodsW
  mov dx, ax
  LodsW
  mov cx, ax
  mov ds, bx
  mov ah, 2Bh
  int 21h
END;


FUNCTION ActTimeStr (Leng : Byte) : TimeString; assembler;
ASM
  mov ah, 2Ch
  int 21h                                        {GetDosTime}
  les di, @Result; cld; mov al, Leng; Stosb;     {StringLnge festlegen}
  mov bh, 10;

  xor ax, ax; mov al, ch
  div bh; add ax, 12336;                         {Bytes in Zeichen umwandeln}
  stosW
  mov al, ':'; stosb

  xor ax, ax; mov al, cl
  div bh; add ax, 12336;   
  stosW
  mov al, ':'; stosb

  xor ax, ax; mov al, dh
  div bh; add ax, 12336;
  stosW
END;


FUNCTION ActDateStr (Leng : Byte) : TimeString; assembler;
ASM
  mov ah, 2Ah; int 21h; mov DayOfWeek, al;               {GetDosDate}
  les di, @Result; cld; mov al, Leng; mov bl, al; Stosb; {StringLnge festlegen}
  mov bh, 10;

  xor ax, ax; mov al, dl
  div bh; add ax, 12336;               {Bytes in Zeichen umwandeln}
  stosW
  mov al, '.'; stosb

  xor ax, ax; mov al, dh
  div bh; add ax, 12336;
  stosW
  mov al, '.'; stosb

  mov  bh, 18
  sub  cx, 1800                 { Jahr-2000-Bercksichtigung }
  @nochmal:
    inc bh                      { bh=Jahrhundert-Zhler }
    sub cx, 100
    cmp cx, 100
  jae @nochmal
  cmp bl, 8
  jbe @weiter
    xor ax, ax; mov al, bh; mov bh, 10
    div bh; add ax, 12336;
    stosW
  @weiter:
  xor ax, ax; mov al, cl; mov bh, 10
  div bh; add ax, 12336;
  stosW
END;


FUNCTION LeapYear (Jahr : Word) : Boolean; assembler;
ASM 
  mov  cx, Jahr
  test cx, 00000011b   { Jahr durch 4 teilbar ? }
  jnz  @NotLeapYear
    mov ax, cx
    cwd                { = mov dx, 0 (nur bei positiven Zahlen) }
    mov bx, 400        { Durch 400 teilbare Jahre sind Schaltjahre }
    div bx
    or  dx, dx         { Ist ein Rest entstanden ? }
    jz  @LeapYear
    mov ax, cx
    cwd                { = mov dx , 0 }
    mov bx, 100        { nicht durch 400, aber durch 100 teilbare Jahre }
    div bx             { sind keine Schaltjahre }
    or  dx, dx
    jnz @LeapYear
  @NotLeapYear:
  xor al, al
  jmp @raus
  @LeapYear:
  mov al, 1
  @raus:
END;
{ Ermittelt, ob Jahr ein Schaltjahr ist }



FUNCTION WeekDay (Tag, Monat : Byte; Jahr : Word) : Byte; assembler;
ASM
  mov  cx, Jahr
  mov  dh, Monat
  mov  dl, Tag
  push dx
  mov  ax, cx
  @nochmal:              { Korrektur fr Daten >= 1.1.3000, da ab hier }
  cmp  ax, 2099          { Rechenfehler auftreten wrden }
  jbe  @los
    sub ax, 400
    jmp @nochmal
  @los:
  mov  cl, dh
  xor  ch, ch
  cmp  cx, 3
  jae  @weiter
    dec ax
    add cx, 12
  @weiter:
  sub  cx, 2

  cwd              { xor  dx, dx }
  mov  bx, 100
  div  bx
  push ax
  push dx

  mov  ax, cx
  cwd              { xor  dx, dx }
  mov  bx, 26
  mul  bx
  dec  ax
  cwd              { xor  dx, dx }
  mov  bx, 10
  div  bx

  pop  bx
  add  ax, bx ; shr bx, 1  ; shr bx, 1
  add  ax, bx

  pop  bx     ; mov cx, bx ; shr bx, 1 ; shr bx, 1
  add  ax, bx

  pop  bx       { Tag }
  xor  bh, bh
  add  ax, bx

  shl  cx, 1
  sub  ax, cx
  add  ax, 49

  cwd           { xor  dx, dx }
  mov  bx, 7
  div  bx
  mov  ax, dx
END;
{ Zellersche Formel, ermittelt die Nummer des Wochentages }
{ 0=Sonntag, 1= Montag usw. }


FUNCTION MonthLen (Month, Year : Word) : Byte;
CONST
  Monate : Array[1..12] of Byte = (31,28,31,30,31,30,31,31,30,31,30,31);
BEGIN
  MonthLen:= Monate[Month]+ord((Month=2) and (LeapYear(Year)));
END;


FUNCTION ParseDate (DateStr : String) : LongInt;
VAR
  d      : DosDateRec;
  l      : LongInt;
  Date   : DateTime;
  tmp    : String;

BEGIN
  ParseDate:= -1;
  If pos ('-', DateStr)<>0 Then Exit;  (* negatives Datum usw. *)
  With Date Do
  BEGIN
    tmp:= nthField (DateStr, ';', 1);
    If Length(nthField(tmp, '.', 3))=0 Then
    BEGIN
      GetDosDate (d);
      year:= d.year;
    END Else
    BEGIN
      year := IntVal (nthField (tmp, '.', 3));
      If year < 100 Then
      If year >= 80 Then inc (year, 1900) Else inc (year, 2000);
    END;
    If (year<1980) or (year>2099) Then Exit;

    month:= IntVal (nthField (tmp, '.', 2));
    If (month=0) or (month>12) Then Exit;

    day:= IntVal (nthField (tmp, '.', 1));
    If (day=0) or (day > MonthLen(month, year)) Then Exit;

    tmp := nthField (DateStr, ';', 2);

    hour:= IntVal (nthField (tmp, ':', 1));
    min := IntVal (nthField (tmp, ':', 2));
    sec := IntVal (nthField (tmp, ':', 3));

    If  (hour>23) or (min>59) or (sec>59)
    or  ((Length(tmp)<>0)
    and ((Length(nthField (tmp, ':', 1))=0)
    or   (Length(nthField (tmp, ':', 2))=0))) Then
    BEGIN ParseDate:=-2; Exit; END;
  END;
  PackTime (Date, l);
  ParseDate:= l;
END;
{ Versucht, aus einem String ein gepacktes Datum/Uhrzeit zu erzeugen.
  Format von DateStr: 'd.m.y;h:m:s'
  Ist das Datum ungltig,   liefert Parsedate -1 zurck.
  Ist die Uhrzeit ungltig, liefert Parsedate -2 zurck.
  Nicht erlaubt sind < 1980, > 2099, 24:00:00
  Fehlt die Uhrzeit, wird 00:00:00 eingesetzt.
  Fehlt das Jahr, wird das aktuelle Jahr verwendet.
  Fehlt Sekunde, wird 0 eingesetzt, Stunde und Minute mssen jedoch
  angegeben werden.
  Zweistellige Jahreszahlen: 80-99 -> 19xx, 00-79 -> 20xx }


FUNCTION GetRelDate (DayDiff : Integer) : LongInt;
VAR
  x  : Integer;
  d  : DosDateRec;
  DT : DateTime;
  l  : LongInt;
  ml : Byte;
BEGIN
  GetDOSDate (d);
  With d Do
  BEGIN
    If DayDiff<0 Then
    For x:= DayDiff To -1 Do
    BEGIN
      dec (Day);
      If Day < 1 Then
      BEGIN
        dec (Month);
        If Month < 1 Then BEGIN dec (year); Month:=12; END;
        Day:= MonthLen (month, year);
      END;
    END
    Else
    BEGIN
      ml:= MonthLen(month, year);
      For x:= 1 To DayDiff Do
      BEGIN
        inc (Day);
        If Day > ml Then
        BEGIN
          inc (Month);
          If Month > 12 Then BEGIN inc (year); Month:=1; END;
          ml:= MonthLen (month, year);
          Day:= 1;
        END;
      END;
    END;

    If (Year < 1980) or (year > 2099) Then l:= -1 Else
    BEGIN
      FillChar (DT, SizeOf (DT), 0);
      DT.day:= day;
      DT.month:= month;
      DT.year:= year;
      PackTime (DT, l);
    END;
    GetRelDate:= l;
  END;
END;
{ Ermittelt das Datum soviele Tage vor oder nach dem aktuellen Datum,
  wie in "DateDiff" angegeben ist. Negative Zahlen ermitteln ein
  Datum in der Vergangenheit, Positive eins in der Zukunft (0=heute).
  -1 = gestern, -2 = vorgestern usw.
  +1 = morgen,  +2 = bermorgen usw.
  Das Datum wird DOS-gepackt. Die Uhrzeit ist auf 00:00:00 gesetzt.
}


FUNCTION SysTime : LongInt; assembler;
ASM
  xor ax, ax
  int 1Ah
  mov ax, dx
  mov dx, cx
END;


PROCEDURE xDelay (t : Word); assembler;
ASM
  xor  dx, dx
  mov  ax, t
  mov  bx, 55
  div  bx

  push ax
  xor  ax, ax
  int  1Ah
  pop  ax
  mov  bx, dx
  xor  dx, dx
  add  ax, bx
  adc  dx, cx

  @loop:
    push ax
    push dx
    xor  ax, ax
    int  1Ah
    mov  bx, dx
    pop  dx
    pop  ax

    mov  di, bx
    or   di, cx
    jz   @raus
    cmp  cx, dx
    jb   @loop
    cmp  bx, ax
    jb   @loop
  @raus:
END;


FUNCTION Seconds : LongInt;
BEGIN
  Seconds:= SysTime * 5 DIV 91;
END;


PROCEDURE StartTime;
BEGIN
  StartSysTime:= SysTime;
END;


FUNCTION EndTime : LongInt;
BEGIN
  EndTime:= SysTime - StartSysTime;
END;


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
