UNIT Vectors;


INTERFACE


FUNCTION  IntVector       (IntNum  : Word)         : Pointer;
FUNCTION  DosIntVector    (IntNum  : Byte)         : Pointer;
PROCEDURE SetIntVector    (IntNum  : Word; IntAddr : Pointer);
PROCEDURE DosSetIntVector (IntNum  : Byte; IntAddr : Pointer);


IMPLEMENTATION



FUNCTION IntVector (IntNum : Word) : Pointer; assembler;
ASM
  cli
  xor ax, ax
  mov es, ax
  mov bx, IntNum
  shl bx, 1
  shl bx, 1 
  mov ax, es:[bx];
  add bx, 2
  mov dx, es:[bx];
  sti
END;
{entspricht GetIntVec - direkt lesen ohne DOS}



FUNCTION DosIntVector (IntNum : Byte) : Pointer; assembler;
ASM
  cli
  mov ah, $35
  mov al, IntNum
  int $21
  mov dx, es
  mov ax, bx
  sti
END;
{entspricht GetIntVec - Lesen mit DOS}



PROCEDURE SetIntVector (IntNum : Word; IntAddr : Pointer); assembler;
ASM
  cli
  cld
  xor ax, ax
  mov es, ax
  mov di, IntNum
  shl di, 1
  shl di, 1 
  mov ax, IntAddr.Word(0)
  stosw
  mov ax, IntAddr.Word(2)
  stosw
  sti
END;
{entspricht SetIntVec - Setzen ohne DOS}



PROCEDURE DosSetIntVector (IntNum : Byte; IntAddr : Pointer); assembler;
ASM
  cli
  push ds
  mov  ah, $25
  mov  al, IntNum 
  mov  dx, IntAddr.Word(0)
  mov  ds, IntAddr.Word(2)
  int  $21
  pop  ds
  sti
END;
{entspricht SetIntVec - Setzen mit DOS}


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
