UNIT VGA;

INTERFACE


FUNCTION  IsVga                : boolean; 
PROCEDURE SetVGAMode     (Mode : Word);
PROCEDURE SetColor      (Color : Byte);
PROCEDURE EnterPixel;
PROCEDURE DrawPixel      (x, y : Integer); 
PROCEDURE ExitPixel; 
PROCEDURE HLine     (x1, x2, y : Word); 
PROCEDURE VLine     (x, y1, y2 : Word);
PROCEDURE PutCircle (xm, ym, r : Word; Farbe : Byte);


IMPLEMENTATION


FUNCTION IsVga : boolean; assembler;
ASM
  mov ax, 1A00h        {Display Combination abfragen}
  int 10h
  cmp al, 1Ah
  mov ax, 1
  je  @ende
  dec ax
  @ende:
END;


PROCEDURE SetVGAMode (Mode : Word); assembler;
ASM
  mov ax, Mode         { Mode-Nr. in AL, AH:= 0 } 
  int 10h
  mov dx, 3CEh
  mov ax, 0003h        { Port[$3CE]:= 3; Index fr Data Rotate Reg. }
  out dx, ax           { Port[$3CF]:= 0; berschreiben einstellen (NormalPut)}
END; 
{ Setzt einen VGA-Modus } 



PROCEDURE SetColor (Color : Byte); assembler;
ASM
  mov dx, 3CEh
  xor al, al           { Port[$3CE]:= 0;     Index fr Set/Reset Register }
  mov ah, Color        { Port[$3CF]:= Color; Farbnummer laden }
  out dx, ax
END;
{ Setzt Farbe fr sptere Schreibaktionen }

 

PROCEDURE EnterPixel; assembler;
ASM
  mov dx, 3CEh
  mov ax, 0F01h        { Port[$3CE]:= 1;   Index fr Enable Set/Reset Reg. }
  out dx, ax           { Port[$3CF]:= $0F; Set/Reset als Datenquelle }
end;
{ Leitet Pixel-malen ein }



PROCEDURE DrawPixel (x, y : Integer); assembler;
ASM
  mov ax, y
  mov bx, 80
  mul bx
  mov cx, x
  mov di, cx
  {$IFOPT G+}
    shr di, 3
  {$ELSE}
    shr di, 1; shr di, 1; shr di, 1
  {$ENDIF}
  add di, ax           {ScrOfs:= y * 80 + x shr 3; Bildspeicher-Offsetadresse }

  mov dx, 3CEh
  mov al, 8            {Port[$3CE]:= 8; Index fr Bit Mask Register }
  and cx, 7
  mov ah, 80h
  shr ah, cl           {BitMask:= $80 shr (x and 7); Bitmaske berechnen }
  out dx, ax           {Port[$3CF]:= BitMask; Bitmaske laden }

  mov ax, $A000
  mov es, ax
  inc Byte Ptr es:[di] {Inc(Mem[$A000:ScrOfs]); Lese/Schreibzyklus erzeugen! }
END;
{ malt ein Pixel, Farbe mit SetColor } 



PROCEDURE ExitPixel; assembler;
ASM
  mov dx, 3CEh         
  mov ax, 0FF01h       {Port[$3CE]:= 1; Index fr Enable Set/Reset Reg. }
  Out dx, ax           {Port[$3CF]:= $FF; Bit Mask Reg. mit Default laden }
  inc dx
  dec al
  out dx, al           {Port[$3CF]:= 0;  mit Default laden }
END;
{ beendet Pixel-malen (Register-Default) }
 
 


PROCEDURE HLine (x1, x2, y : Word); assembler;
ASM
  mov cx, x1; cmp cx, x2; ja @ende      { Wenn x1 > x2, sofort beenden }
  mov ax, y
  mov bx, 80
  mul bx
  mov di, cx
  {$IFOPT G+}
    shr di, 3
  {$ELSE}
    shr di, 1; shr di, 1; shr di, 1
  {$ENDIF}
  mov dx, di
  add di, ax       {ScrOfs:= y * 80 + x1 div 8; Bildspeicher-Offsetadresse }

  mov bx, x2
  mov si, bx
  {$IFOPT G+}
    shr bx, 3
  {$ELSE}
    shr bx, 1; shr bx, 1; shr bx, 1
  {$ENDIF}
  sub bx, dx       {HLength:= x2 div 8-x1 div 8; Lnge der Linie in Bytes-1}

  and cx, 7
  mov ax, $FF
  shr ax, cl       {LMask:= $FF shr (x1 and 7); linke Randmaske berechnen }

  and si, 7
  mov cx, 7
  sub cx, si
  mov si, $FF
  shl si, cl       {RMask:= $FF shl (7-(x2 and 7));rechte Randmaske berechnen}


  or  bx, bx       {wenn (HLength) nur ein Byte dann linke } 
  jnz @weiter      {und rechte Maske verknpfen } 
  and ax, si
  @weiter:

  mov cx, ax       {push ax}
  mov dx, 3CEh
  mov ax, 0F01h    {Port[$3CE]:= 1; Index Enable Set/Reset Reg. }
  out dx, ax       {Port[$3CF]:= $0F;  Set/Reset als Datenquelle }
                   { --- Linie zeichnen --- }
  mov ah, cl       {pop ax}
  mov al, 8        {Port[$3CE]:= 8; Index fr Bit Mask Register }
  out dx, ax       {Port[$3CF]:= LMask; Randmaske fr erstes Byte }

  mov ax, $A000
  mov es, ax
  inc Byte Ptr es:[di]  {Inc (Mem[$A000:ScrOfs]); Lese/Schreibzyklus erzeugen}

  or  bx, bx
  jz  @fertig

  inc di                {Inc(ScrOfs);  nchste Bildspeicheradresse }
  dec bx                {Dec(HLength); verbleibende Lnge }

  inc dx                {dx = 3CFh}
  mov al, $FF           
  out dx, al            {Port[$3CF]:= $FF; Bitmaske FFh laden }

  mov cx, bx
  rep stosb   {FillChar(Mem[$A000:ScrOfs],HLength,$FF);Mittlerer Teil d.Linie} 
              {inc(ScrOfs,HLength); Offsetadresse erhhen }
  mov ax, si
  out dx, al            {Port[$3CF]:= RMask; Randmaske fr letztes Byte }

  inc Byte Ptr es:[di]  {Inc( Mem[$A000:ScrOfs]); Lese/Schreibzyklus erzeugen}

  @fertig:
                        { --- Register aufrumen --- }
  dec dx                {dx = 3CEh}
  mov ax, 0FF01h
  out dx, ax
  inc dx
  dec al
  out dx, al           {Port[$3CF]:= 0;  mit Default laden }

  @ende:
END;
{ eine schnelle horizontale Linie } 




PROCEDURE VLine (x, y1, y2 : Word); assembler;
ASM
  mov si, y1
  mov ax, si
  mov bx, 80
  mul bx
  mov cx, x
  mov di, cx
  {$IFOPT G+}
    shr di, 3
  {$ELSE}
    shr di, 1; shr di, 1; shr di, 1
  {$ENDIF}
  add di, ax         {ScrOfs:= y1 * 80 + x shr 3; Bildspeicher-Offsetadresse }

  and cx, 7
  mov bl, 80h
  shr bl, cl         {BitMask:= $80 shr (x and 7); Bitmaske berechnen }

  mov dx, 3CEh
  mov ax, 0F01h      {Port[$3CE]:= 1; Index fr Enable Set/Reset }
  out dx, ax         {Port[$3CF]:= $0F; Set/Reset als Datenquelle }

  mov al, 8          {Port[$3CE]:= 8;Index fr Bit Mask Register }
  mov ah, bl         {Port[$3CF]:= BitMask; Bitmaske laden }
  out dx, ax

  mov ax, $A000
  mov es, ax
  mov cx, y2
  inc cx
  sub cx, si         {for y:= y1 to y2 do ...}
  @nochmal:
    inc Byte Ptr es:[di] {Inc(Mem[$A000:ScrOfs]); Lese/Schreibzyklus erzeugen} 
    add di, 80           {inc(ScrOfs, 80); Offsetadr. eine Zeile weiter}
  loop @nochmal

  { mu berhaupt ? }
  mov ax, 0FF08h     {Port[$3CE]:= 8; Index fr Bit Mask Register }
  out dx, ax         {Port[$3CF]:= $FF; Default-Bitmaske }
  mov ax, 0001h      {Port[$3CE]:= 1;Index fr Enable Set/Reset }
  out dx, ax         {Port[$3CF]:= 0; Enable Set/Reset-Default }
END;
{ eine schnelle senkrechte Linie }
 


PROCEDURE PutCircle (xm, ym, r : Word; Farbe : Byte); assembler;
VAR
  px, py : Word;
ASM
  PUSH DS

  MOV  DX, 3CEH     { Setze ENABLE_SET_RES_REG:= 0F und SET_RES_REG:= FARBE }
  MOV  AX, 0F01h    { ENABLE_SET_RES_REG:= 0F}
  OUT  DX, AX
  MOV  AL, 0        { -> SET_RESET_REG}
  MOV  AH, Farbe
  OUT  DX, AX       { SET_RES_REG:= FARBE}

  MOV  AL, 8        { -> BIT_MASK_REG}
  OUT  DX, AL
  INC  DX           { DX -> 3CFh}

  MOV  AX, $A000
  MOV  DS, AX

  SUB  BX, BX
  MOV  CX, R
  MOV  SI, CX

  {----------- Hauptschleife------------------}

@PutCircle_2:
  OR   SI, SI
  JNS  @PutCircle_4
  DEC  CX
  ADD  SI, CX
  ADD  SI, CX
                   { Zeichne 8 Punkte des Kreises }

@PutCircle_4:
  PUSH SI
  MOV  PY, CX      { Rette PY und PX}
  MOV  PX, BX

  ADD  BX, XM
  MOV  CX, BX
  AND  CL, 7       { X1 mod 8}
  MOV  AL, 80h
  SHR  AL, CL      { Bit_Pos}
  OUT  DX, AL      { ins BIT_MASK_REG}

                   { X1/8}
  {$IFOPT G+}
    shr bx, 3
  {$ELSE}
    shr bx, 1; shr bx, 1; shr bx, 1
  {$ENDIF}
  MOV  DI, BX      { fr spter}

  MOV  AX, YM
  ADD  AX, PY      { AX = Y1}
  mov  dx, 80
  mul  dx

  ADD  BX, AX      { Screenadr = X1/8 + 80*Y1 }
  XCHG SI, AX      { 80*Y1 fr spter}
  inc Byte Ptr [bx]{ Dummy Read/Write }
                   { DI hat X1/8 }
  MOV  AX, YM      
  SUB  AX, PY
  mov  dx, 80
  mul  dx
  PUSH AX          { fr spter}
  ADD  DI, AX      { Screenadr = X1/8 + 80*Y2 }
  inc Byte Ptr [di]{ Dummy Read/Write}
                   { TOS hat 80*Y2 }
  MOV  BX, XM 
  SUB  BX, PX      { BX:= X3 }
  MOV  CX, BX
  AND  CL, 7       { X3 mod 8 }
  MOV  AL, 80h
  SHR  AL, CL      { Bit_Pos }

  mov  dx, $3CF
  OUT  DX, AL      { in's BIT_MASK_REG}

                   { X3/8}
  {$IFOPT G+}
    shr bx, 3
  {$ELSE}
    shr bx, 1; shr bx, 1; shr bx, 1
  {$ENDIF}
  MOV  DI, BX      { fr spter}

  POP  AX          { AX:= 80*Y2}
  ADD  BX, AX      { Screenadr = X3/8 + 80*Y2}
  inc Byte Ptr [bx]{ Dummy Read/Write}
                   { DI hat X3/8 und SI hat 80*Y1 }
  ADD  DI, SI      { Screenadr = X3/8 + 80*Y1 }
  XCHG [DI], AL    { Dummy Read/Write }

  MOV  BX, XM
  ADD  BX, PY      { BX:= X5}
  MOV  CX, BX
  AND  CL, 7       { X5 mod 8}
  MOV  AL, 80h
  SHR  AL, CL      { BitPos}
  mov  dx, $3CF
  OUT  DX, AL      { ins BIT_MASK_REG}

                   { X5/8}
  {$IFOPT G+}
    shr bx, 3
  {$ELSE}
    shr bx, 1; shr bx, 1; shr bx, 1
  {$ENDIF}
  MOV  DI, BX      { fr spter}

  MOV  AX, YM
  ADD  AX, PX      { AX:= Y5:= YM+PX}
  mov  dx, 80
  mul  dx
  ADD  BX, AX      { ScreenAdr = X5/8 + 80*Y5}
  XCHG SI, AX      { 80*Y5 fr spter}
  inc Byte Ptr [bx]{ Dummy Read/Write}
                   { DI hat X5/8 }
  MOV  AX, YM
  SUB  AX, PX      { AX:= Y6:= YM-PX}
  mov  dx, 80
  mul  dx
  PUSH AX
  ADD  DI, AX      { ScreenAdr = X5/8 + 80*Y6}
  inc Byte Ptr [di]{ Dummy Read/Write}
                   { TOS hat 80*Y6}
  MOV  BX, XM      { XM }
  SUB  BX, PY      { BX:= X7:= XM-PY}
  MOV  CX, BX 
  AND  CL, 7       { X7 mod 8}
  MOV  AL, 80h
  SHR  AL, CL      { BitPos}
  mov  dx, $3CF
  OUT  DX, AL      { ins BIT_MASK_REG}

                   { X7/8}
  {$IFOPT G+}
    shr bx, 3
  {$ELSE}
    shr bx, 1; shr bx, 1; shr bx, 1
  {$ENDIF}
  MOV  DI, BX      { fr spter}

  POP  AX          { AX:= 80*Y6}
  ADD  BX, AX      { ScreenAdr = X7/8 + 80*Y6}
  inc Byte Ptr [bx]{ Dummy Read/Write}
                   { DI hat X7/8   SI hat 80*Y5 }

  ADD  DI, SI      { ScreenAdr = X7/8 + 80*Y5}
  inc Byte Ptr [di]{ Dummy Read/Write}

  MOV  CX, PY
  MOV  BX, PX
  POP  SI

  SUB  SI, BX
  SUB  SI, BX
  DEC  SI

  INC  BX
  CMP  CX, BX
  JBE  @PutCircle_0   { ja, fertig }
  JMP  @PutCircle_2   { Nein, loop }

@PutCircle_0:
  POP  DS

END;


END.




{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
