UNIT Volume;

INTERFACE

USES
  Dos, Strings, Find_FCB;

TYPE
  ExtFCB    = RECORD
                Flag    : Byte;                  { immer $FF ! }
                Res1    : Array[1..5] Of Byte;   { auf 0 setzen }
                Attr    : Byte;                  { Dateiattribut }
                DriveNr : Byte;                  { Laufwerksnummer, 1=A 2=b }
                Name    : Array[1..8] Of Char;   { Datei-Name }
                Ext     : Array[1..3] Of Char;   { Datei-Endung }
                Res2    : Array[1..5] Of Byte;
                NewName : Array[1..8] Of Char;   { zum Umbenennen }
                NewExt  : Array[1..3] Of Char;
                Res3    : Array[1..9] Of Byte;
              END;
              { Rest der Namensfelder mit Leerzeichen fllen, VolumeLabel
                einfach durch beide "Name"-Arrays durchschreiben }

  MIDRec    = RECORD
                Infolevel   : Word;        { immer 0 }
                VolumeID    : Array[1..4]  Of Byte;
                VolumeLabel : Array[1..11] Of Char;
                FileSysType : Array[1..8]  Of Char; { z.B. "FAT12"}
              END;

  TLabelRec = RECORD
                VolumeFileName : String[11];
                VolumeBootName : String[11];
                VolumeNr       : Array [1..4] Of Byte;
                VolumeFileSys  : String[8];      { z.B. "FAT12"}
                VolumeFlag     : Word;
              END;

CONST
  DriveNotReady  = 1;   { Laufwerk nicht bereit (Disk fehlt o.. ) }
  LFNFound       = 2;   { Langen Dateinamen von Windows gefunden }
  FileLabelFound = 4;   { Label-Datei gefunden }
  IsLabelFirst   = 8;   { Label-Datei vor allen langen Dateinamen gefunden ?}
  BootLabelFound = 16;  { Bootsektor-Label gefunden }
  IsNetDrive     = 32;  { Laufwerk ist ein Netzlaufwerk (z.B. CD-ROM) }

PROCEDURE GetVolumeLabel (DriveLetter : Char; VAR LabelRec : TLabelRec);
PROCEDURE GetMediaID     (DriveLetter : Char; VAR MID      : MIDRec);

IMPLEMENTATION


PROCEDURE GetMediaID (DriveLetter : Char; VAR MID : MIDRec); assembler;
ASM
  push ds

  mov  ax, 4409h
  mov  bl, DriveLetter
  and  bx, 31
  int  21h
  jc   @ende                            { Allgemeiner Fehler ? }

  test dx,  1000h                       { Netzlaufwerk ? }
  jz   @w2; mov ax, 2; jmp @ende; @w2:

  test dl,  01000000b                   { Untersttzt Treiber 440Dh ? }
  jnz  @w3; mov ax, 3; jmp @ende; @w3:

  mov  ax, 440Dh
  mov  bl, DriveLetter
  and  bx, 31
  mov  cx, 0866h
  lds  dx, MID
  int  21h
  jc   @ende
  xor  ax, ax
  @ende:
  pop  ds
  mov  InOutRes, ax
END;
{ Ermittelt VolumeNamen und Datentrgernummer aus dem Bootsektor
  eines Datenrgers. Kann nicht auf Netzlaufwerke angewendet werden
  und meldet einen Fehler (5), wenn die Diskette keinen Erweiterten
  BIOS-Parameterblock enthlt, also weder Datentrger-Namen noch -Nummer.

  Fehlercodes (mit IOResult abfragen):
  0  = Vorgang erfolgreich
  1  = Funktion nicht untersttzt
  2  = Laufwerk ist ein Netzlaufwerk (z.B. ein CD-ROM-Laufwerk)
  3  = Treiber untersttzt Funktion 440Dh (GetMediaID) nicht
  5  = Laufwerk nicht bereit (z.B. Diskette fehlt) ODER
       Diskette enthlt keinen Erweiterten BIOS-Parameterblock
  15 = Laufwerk existiert nicht (0Fh)
}


PROCEDURE SetMediaID (DriveLetter : Char; VAR MID : MIDRec); assembler;
ASM
  push ds

  mov  ax, 4409h
  mov  bl, DriveLetter
  and  bx, 31
  int  21h
  jc   @ende                            { Allgemeiner Fehler ? }

  test dx,  1000h                       { Netzlaufwerk ? }
  jz   @w2; mov ax, 2; jmp @ende; @w2:

  test dl,  01000000b                   { Untersttzt Treiber 440Dh ? }
  jnz  @w3; mov ax, 3; jmp @ende; @w3:

  mov  ax, 440Dh
  mov  bl, DriveLetter
  and  bx, 31
  mov  cx, 0846h
  lds  dx, MID
  int  21h
  jc   @ende
  xor  ax, ax
  @ende:
  pop  ds
  mov  InOutRes, ax
END;
{ Setzt VolumeNamen und Datentrgernummer. Bestehende Daten mssen/sollten
  vorher mit GetMediaID abgefragt werden. }
 


PROCEDURE RenameLabelFile (DriveLetter : Char; OldName, NewName : String); assembler;
VAR
  RenFCB : ExtFCB;
ASM
  push ds

  mov  dx, Seg RenFCB
  mov  es, dx
  mov  di, Offset RenFCB
  mov  bx, di              { Offset fr spter merken }

  mov  al, $FF             { Flag setzen, $FF=ExtendedFCB }
  stosb
  mov  cx, 5
  xor  al, al
  rep  stosb               { Feld Res1 mit Nullbytes fllen }
  mov  al, 8
  stosb                    { Attribut VolumeID in FCB schreiben }

  mov  al, DriveLetter
  and  al, 31
  stosb                    { DriveNr in FCB schreiben }

  lds  si, OldName; lodsb; xor ah, ah;  
  cmp  ax, 11; jbe  @w1; mov ax, 11; @w1:    { Lnge des Namens ggf. kappen }
  mov  cx, ax; inc ax; jcxz @raus
  mov  al, cl
  rep  movsb               { alten Labelnamen kopieren }
  mov  cl, 11
  sub  cl, al
  mov  al, ' '
  rep  stosb               { Rest mit Leerzeichen fllen }

  add  di, 5               { Reservierte Bytes berspringen }

  lds  si, NewName; lodsb; xor ah, ah;
  cmp  ax, 11; jbe  @w2; mov ax, 11; @w2: { Lnge des Namens ggf. kappen }
  mov  cx, ax; inc ax; jcxz @raus
  mov  al, cl
  rep  movsb               { neuen Labelnamen kopieren }
  mov  cl, 11
  sub  cl, al
  mov  al, ' '
  rep  stosb               { Rest mit Leerzeichen fllen }

  mov  ah, 17h             { "Rename File with FCB" }
  mov  ds, dx              { in DX noch Seg RenFCB }
  mov  dx, bx              { gemerkten Offset nach DX }
  int  21h

  @raus:
  pop  ds
  xor  ah, ah
  mov  InOutRes, ax
END;
{ Benennt eine Volume-Label-Datei um.
  Besonderheiten:
  - funktioniert nicht, wenn eine andere (normale) Datei bereits den
    Namen "Newname" trgt
  - das Label im Bootsektor wird NICHT mitgendert
  - funktioniert auch auf Win-9x-Disketten, die lange Dateinamen
    enthalten
  - Lschen eines Labels nicht mglich

  Einsatzgebiete:
  - Win 9x-Disketten, die lange Dateinamen enthalten, das Bootsektorlabel
    mu gesondert umbenannt werden (SetMediaID o..)

  Der alte Labelname mu vorher mit GetVolumeLabel korrekt ermittelt werden.

  Fehlercodes (mit IOResult ermitteln):
    0   = Umbenennen war erfolgreich
    1   = alter oder/und neuer Labelname fehlte
    255 = Umbenennen fehlgeschlagen
}


PROCEDURE DeleteLabelFile (DriveLetter : Char; SeekName : String); assembler;
VAR
  DelFCB : ExtFCB;
ASM
  push ds

  mov  dx, Seg DelFCB
  mov  es, dx
  mov  di, Offset DelFCB
  mov  bx, di              { Offset fr spter merken }

  mov  al, $FF             { Flag setzen, $FF=ExtendedFCB }
  stosb
  mov  cx, 5
  xor  al, al
  rep  stosb               { Feld Res1 mit Nullbytes fllen }
  mov  al, 8
  stosb                    { Attribut VolumeID in FCB schreiben }

  mov  al, DriveLetter
  and  al, 31
  stosb                    { DriveNr in FCB schreiben }

  lds  si, SeekName; lodsb; xor ah, ah
  cmp  ax, 11; jbe  @w1; mov ax, 11; @w1:    { Lnge des Namens ggf. kappen }
  mov  cx, ax; inc ax; jcxz @raus

  mov  al, cl
  rep  movsb               { Dateinamen kopieren }
  mov  cl, 11
  sub  cl, al
  mov  al, ' '
  rep  stosb               { Rest mit Leerzeichen fllen }

  mov  ds, dx
  mov  dx, bx
  mov  ah, 13h
  int  21h                 { Delete File with FCB }

  @raus:
  pop  ds
  xor  ah, ah
  mov  InOutRes, ax
END;
{ Lscht eine Label-Datei. Wenn der Datentrger einen Erweiterten
  BIOS-Parameterblock enthlt, wird das Label im Bootsektor auf "NO NAME"
  gesetzt.

  Darf nicht auf Windows-Disketten mit langen Dateinamen angewendet
  werden, wenn das Label spter wieder gesetzt (das Label also
  eigentlich nur umbenannt) werden soll.  

  Fehlercodes (mit IOResult ermitteln):
    0   = Lschen war erfolgreich
    1   = Labelname fehlte
    255 = Lschen fehlgeschlagen
}


PROCEDURE CreateLabelFile (DriveLetter : Char; NewName : String); assembler;
VAR
  DelFCB : ExtFCB;
ASM
  push ds

  mov  dx, Seg DelFCB
  mov  es, dx
  mov  di, Offset DelFCB
  mov  bx, di              { Offset fr spter merken }

  mov  al, $FF             { Flag setzen, $FF=ExtendedFCB }
  stosb
  mov  cx, 5
  xor  al, al
  rep  stosb               { Feld Res1 mit Nullbytes fllen }
  mov  al, 8
  stosb                    { Attribut VolumeID in FCB schreiben }

  mov  al, DriveLetter
  and  al, 31
  stosb                    { DriveNr in FCB schreiben }

  lds  si, NewName; lodsb; xor ah, ah
  cmp  ax, 11; jbe  @w1; mov ax, 11; @w1:    { Lnge des Namens ggf. kappen }
  mov  cx, ax; inc ax; jcxz @raus

  mov  al, cl
  rep  movsb               { Dateinamen kopieren }
  mov  cl, 11
  sub  cl, al
  mov  al, ' '
  rep  stosb               { Rest mit Leerzeichen fllen }

  mov  ds, dx
  mov  dx, bx
  mov  ah, 16h
  int  21h                 { Create File with FCB }

  or   al, al
  jnz  @raus

  mov  ah, 10h
  int  21h                 { Close File with FCB }

  @raus:
  pop  ds
  xor  ah, ah
  mov  InOutRes, ax
END;
{ Erzeugt eine Label-Datei. Wenn der Datentrger einen Erweiterten
  BIOS-Parameterblock enthlt, wird auch das Label im Bootsektor gesetzt.

  Darf nicht auf Windows-Disketten mit langen Dateinamen angewendet
  werden.  

  Fehlercodes (mit IOResult ermitteln):
    0   = Erzeugen war erfolgreich
    1   = Labelname fehlte
    255 = Erzeugen fehlgeschlagen
}



PROCEDURE GetVolumeLabel (DriveLetter : Char; VAR LabelRec : TLabelRec);
VAR
  sr     : TSearchRec;
  p      : Byte;
  MID    : MIDRec;

BEGIN
  FillChar (LabelRec, SizeOf (TLabelRec), 0);

  With LabelRec Do
  BEGIN
    FindFirstFCB (DriveLetter+':\*.*', VolumeID, sr);

    If (DOSError>=150) and (DOSError<>255) Then
    BEGIN VolumeFlag:= VolumeFlag or DriveNotReady; Exit; END; 

    While (DosError=0)
    and   (VolumeFlag and (LFNFound or FileLabelFound) <> LFNFound or FileLabelFound) Do
    BEGIN
      If sr.attr and 15 = 15 Then         { Langen Windows-Dateinamen gefunden }
      VolumeFlag:= VolumeFlag or LFNFound
      Else
      If (VolumeFlag and FileLabelFound = 0) and (sr.attr and VolumeID<>0) Then
      BEGIN
        VolumeFileName:= sr.TrueName; { echten Volume-Namen gefunden }
        VolumeFlag:= Volumeflag or FileLabelFound;
        If VolumeFlag and LFNFound = 0 Then
        VolumeFlag:= Volumeflag or IsLabelFirst;
      END;
      FindNextFCB (sr);
    END;

    GetMediaID (DriveLetter, MID);
    CASE IOResult Of
      0 : BEGIN
            Move (MID.VolumeID,    VolumeNr, 4); 
            Move (MID.VolumeLabel, VolumeBootName[1], 11);
            VolumeBootName[0]:= #11;
            VolumeBootName   := Trim (VolumeBootName);

            Move (MID.FileSysType, VolumeFileSys[1], 8);
            VolumeFileSys[0]:= #8;
            VolumeFileSys   := Trim (VolumeFileSys);

            VolumeFlag:= VolumeFlag or BootLabelFound;
          END;
      2 : VolumeFlag:= VolumeFlag or IsNetDrive;
    END;
  END;
END;


END.




{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
