UNIT WildCard;

INTERFACE
USES
  Strings;

FUNCTION FileMatch  (Name,   WildCards : String) : Boolean;
FUNCTION StrMatch   (Quelle, WildCard  : String) : Boolean;
FUNCTION IsWildCard (Path              : String) : Boolean;

IMPLEMENTATION


FUNCTION Lessest (p1, p2 : Byte) : Byte; assembler;
ASM
  mov al, p1
  mov ah, p2
  cmp al, ah
  jae @ae
    or al, al
    jnz @ende
    mov al, ah
    jmp @ende
  @ae:
    or ah, ah
    jz @ende
    mov al, ah
  @ende:
END;
{ ermittelt die kleinste der beiden Zahlen p1 und p2. Ist jedoch einer der
  beiden Werte=0, dann wird der grere Wert (der <>0 ist) zurckgegeben.
  Sind beide Werte 0, wird 0 zurckgegeben. }
  

FUNCTION NextChars (s : String; Start : Byte) : String;
VAR
  p  : Word;
  nc : String;
BEGIN  
  nc:= copy (s, Start, 255);
  p := Lessest (pos ('*', nc), pos ('?', nc));
  If p=0 Then NextChars:= nc Else NextChars:= copy (nc, 1, p-1);
END;


FUNCTION Equal (Name : String; WildCard : String) : Boolean;
VAR
  x, x1, p : Byte;
LABEL
  Ende;
BEGIN
  x1:= 0;
  For x:=1 To Length(WildCard) Do
  BEGIN
    If WildCard[x]='*' Then
    BEGIN
      If x=Length(WildCard) Then
      BEGIN
        Equal:= TRUE; Exit;
      END
      Else
      BEGIN
        inc (x);   { ist bis jetzt noch nicht schiefgegangen }
        x1:= LastInStr (succ(x1), UpStr(Name), UpStr(NextChars(WildCard, x)));
        If x1=0 Then BEGIN Equal:= FALSE; Exit; END;
      END;
    END
    Else
    BEGIN
      inc (x1);
      If (x1>Length(Name)) or ((WildCard[x]<>'?') and (UpChar(WildCard[x])<>UpChar(Name[x1]))) Then
      BEGIN Equal:= FALSE; Exit; END;
    END;
  END;

Ende:
  Equal:= x1 >= Length (Name);
END;


FUNCTION FMatch (Name, WildCard : String) : Boolean;
VAR
  p : Word;
  w1, w2, n1, n2 : String;
BEGIN
  While pos('*?', WildCard)<>0 Do WildCard:= ReplaceAll(WildCard, '*?', '?*');
  While pos('**', WildCard)<>0 Do WildCard:= ReplaceAll(WildCard, '**', '*');

  If (copy (WildCard, 1, 1)='.') or (Length(WildCard)=0) Then insert ('*', WildCard, 1);

  p:= LastPos ('.', WildCard);
  If p=0 Then FMatch:= Equal (Name, WildCard) Else
  BEGIN
    w1:= copy (WildCard, 1,   p-1);
    w2:= copy (WildCard, p+1, 255);
    
    p:= LastPos ('.', Name);
    If p<>0 Then
    BEGIN
      n1:= copy (Name, 1,   p-1);
      n2:= copy (Name, p+1, 255);
    END
    Else
    BEGIN
      n1:= Name;
      n2:= '';
    END;

    FMatch:= Equal (n1, w1) and Equal (n2, w2);
  END;
END;


FUNCTION FileMatch (Name, WildCards : String) : Boolean;
VAR
  x : Byte;
BEGIN
  For x:= 1 To CountFields (WildCards, '+') Do
  If FMatch (Name, nthField (WildCards, '+', x)) Then
  BEGIN
    FileMatch:= TRUE;
    Exit;
  END;
  FileMatch:= FALSE;
END;


FUNCTION StrMatch (Quelle, WildCard : String) : Boolean;
BEGIN
  While pos('*?', WildCard)<>0 Do WildCard:= ReplaceAll(WildCard, '*?', '?*');
  While pos('**', WildCard)<>0 Do WildCard:= ReplaceAll(WildCard, '**', '*');
  StrMatch:= Equal (Quelle, WildCard);
END;
{ Punkte haben hier keine besondere Bedeutung }
 

FUNCTION IsWildCard (Path : String) : Boolean; assembler;
ASM
  push ds
  lds  si, Path
  xor  cx, cx
  mov  cl, [si]
  jcxz @false
  add  si, cx
  std
  @loop:
    lodsb
    cmp al, '*'
    je  @true
    cmp al, '?'
    je  @true
    cmp al, '\'
    je  @false
    cmp al, ':'
  loopne @loop
  @false:
    mov al, FALSE
    jmp @raus
  @true:
    mov al, TRUE
  @raus:
  cld
  pop ds
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
