UNIT WritText;

INTERFACE
USES
  Compare, Dos;


PROCEDURE OpenOutText  (Name : String);
PROCEDURE CloseOutText;
PROCEDURE FlushBuffer;
PROCEDURE WriteChr       (ch : Char);
FUNCTION  TextOutPos         : LongInt;
PROCEDURE SeekOutPos    (Pos : LongInt);

VAR
  OutFile   : File;
  OutSize   : LongInt;
CONST
  OutChkSum : Word = 0;


IMPLEMENTATION

CONST
  BufSize = 8192;

VAR
  TextLen  : LongInt;
  TextPtr  : LongInt;
  BufPtr   : Word;
  BufEnd   : Word;
  Buffer   : Array[1..BufSize] Of Char;



PROCEDURE OpenOutText (Name : String);
BEGIN
  FileMode:= 2;
  Assign  (OutFile, Name);
  Rewrite (OutFile, 1);
  If IOResult<>0 Then BEGIN SetFAttr (OutFile, 32); Rewrite (OutFile, 1); END;
  BufPtr  := 0;
  TextPtr := 0;
  TextLen := 0;
END;



PROCEDURE FlushBuffer;
BEGIN
  If BufPtr<>0 Then
  BEGIN
    inc (OutChkSum, CheckSum (Buffer, BufPtr));
    BlockWrite (OutFile, Buffer, BufPtr, BufEnd);
  END;
  BufPtr:= 0;
  TextPtr:= FilePos (OutFile);
  If TextPtr > TextLen Then TextLen:= TextPtr;
  OutSize:= TextLen;
END;



PROCEDURE CloseOutText;
BEGIN
  FlushBuffer;
  Close (OutFile);
END;



PROCEDURE WriteChr (ch : Char);
BEGIN
  If BufPtr>=BufSize Then FlushBuffer;
  inc (BufPtr);
  Buffer[BufPtr]:= ch;
END;



FUNCTION TextOutPos : LongInt; assembler;
ASM
  mov dx, Word Ptr TextPtr[2]
  mov ax, Word Ptr TextPtr[0]
  add ax, BufPtr
  adc dx, 0
END;
(*TextOutPos:= TextPtr + BufPtr;*)



PROCEDURE SeekOutPos (Pos : LongInt);
BEGIN
  FlushBuffer;
  Seek (OutFile, Pos);
  TextPtr:= Pos;
END;



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
